<?php
/*
 * @ https://t.me/matrix_channel
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 10/08/2022
 */

// Decoded file for php version 72.
echo "<!DOCTYPE html>\n<html>\n<head>\n\t<title>Image and Video Slideshow</title>\n\t<style>\n\t\tbody {\n\t\t\tmargin: 0;\n\t\t\tpadding: 0;\n\t\t}\n\t\timg, video {\n\t\t\tposition: absolute;\n\t\t\ttop: 0;\n\t\t\tleft: 0;\n\t\t\twidth: 100%;\n\t\t\theight: 100%;\n\t\t\tobject-fit: cover;\n\t\t}\n\t\t.slide-indicator {\n\t\t\tdisplay: inline-block;\n\t\t\twidth: 10px;\n\t\t\theight: 10px;\n\t\t\tbackground-color: gray;\n\t\t\tborder-radius: 50%;\n\t\t\tmargin: 5px;\n\t\t\tcursor: pointer;\n\t\t}\n\t\t.active {\n\t\t\tbackground-color: white;\n\t\t}\n\t</style>\n</head>\n<body>\n\t<div id=\"slideshow\"></div>\n\t<div id=\"slide-indicators\"></div>\n\n<script>\n    var slideshow = document.getElementById(\"slideshow\");\n\n    fetch('ads.php')\n        .then(response => response.json())\n        .then(data => {\n            var mediaUrls = data.map(obj => obj.AdUrl);\n            loadSlides(mediaUrls);\n        });\n\n    function getMediaType(url) {\n        var extension = url.split('.').pop();\n        if (extension == \"jpg\" || extension == \"jpeg\" || extension == \"png\" || extension == \"gif\") {\n            return \"image\";\n        } else if (extension == \"mp4\") {\n            return \"video\";\n        } else {\n            return null;\n        }\n    }\n\n    function loadSlides(mediaUrls) {\n        var i;\n        for (i = 0; i < mediaUrls.length; i++) {\n            var mediaType = getMediaType(mediaUrls[i]);\n            var slideElement;\n            if (mediaType == \"image\") {\n                slideElement = document.createElement(\"img\");\n                slideElement.src = mediaUrls[i];\n            } else if (mediaType == \"video\") {\n                slideElement = document.createElement(\"video\");\n                slideElement.src = mediaUrls[i];\n                slideElement.autoplay = true;\n                slideElement.controls = false; // disable controls\n                slideElement.muted = true; // mute video for autoplay\n                slideElement.loop = false; // don't loop video\n                slideElement.addEventListener('ended', function () {\n                    setTimeout(showSlides, 0); // move to next slide when video ends\n                });\n            }\n            slideshow.appendChild(slideElement);\n            slideElement.style.opacity = \"0\";\n        }\n        showSlides();\n    }\n\n    var slideIndex = 0;\n\n    function showSlides() {\n        var i;\n        var slides = slideshow.childNodes;\n        for (i = 0; i < slides.length; i++) {\n            if (slides[i].tagName == \"IMG\" || slides[i].tagName == \"VIDEO\") {\n                slides[i].style.display = \"none\";\n            }\n        }\n        slideIndex++;\n        if (slideIndex > slides.length) {\n            slideIndex = 1\n        }\n        if (slides[slideIndex - 1].tagName == \"IMG\") {\n            slides[slideIndex - 1].style.display = \"block\";\n            fadeIn(slides[slideIndex - 1]);\n            setTimeout(showSlides, 5000); // Change slide every 5 seconds for images\n        } else if (slides[slideIndex - 1].tagName == \"VIDEO\") {\n            slides[slideIndex - 1].style.display = \"block\";\n            fadeIn(slides[slideIndex - 1]);\n            slides[slideIndex - 1].play();\n        }\n    }\n\n    function fadeIn(element) {\n        var op = 0.1; // initial opacity\n        element.style.opacity = op;\n        var timer = setInterval(function () {\n            if (op >= 1) {\n                clearInterval(timer);\n            }\n            element.style.opacity = op;\n            element.style.filter = 'alpha(opacity=' + op * 100 + \")\";\n            op += op * 0.1;\n        }, 50);\n    }\n</script>\n\n</body>\n</html>\n";

?>